using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

using Microsoft.DirectX;

using DarkStrideToolbox;

namespace DarkStride.StellarLanes.SharedDLL
{
    public class Zones : System.Collections.Generic.SortedList<string, Zone>
    {
        #region Member Variables
        #endregion

        public void Advance(Session oSession, double nElapsedTime)
        {
            foreach (Zone oLoopZone in this.Values)
            {
                oLoopZone.Advance(oSession,nElapsedTime);
            }
        }
        public void Add(Zone oZone)
        {
            this.Add(oZone.PKey, oZone);
        }

        public Entity GetEntity(string sEntityGuid)
        {
            Entity oEntity = null;

            foreach (Zone oLoopZone in this.Values)
            {
                if (oLoopZone.Entitys.ContainsKey(sEntityGuid) == true)
                {
                    oEntity = oLoopZone.Entitys[sEntityGuid];
                    break;
                }
            }

            return (oEntity);
        }
        public void AddEntity(Session oSession,Entity oEntity, bool bResentIntoNetwork)
        {
            Zone oZone = this[oEntity.MostUpToDateLoc.ZoneID.ToString()];
            if (oZone.Entitys.ContainsKey(oEntity.PKey) == false)
            {
                oZone.AddEntity(oSession, oEntity, bResentIntoNetwork);
            }
        }
        public void ChangeZone(Session oSession, Entity oEntity)
        {
            foreach (Zone oLoopZone in this.Values)
            {
                if (oLoopZone.Entitys.ContainsKey(oEntity.PKey) == true &&
                    oLoopZone.ZoneID != oEntity.Location.ZoneID )
                {
                    oLoopZone.Entitys.Remove(oEntity.PKey);
                }
            }

            AddEntity(oSession,oEntity,false);
        }

        public Zones GetShallowCopy()
        {
            Zones oCopyOfZones = null;


            //Copy the zones to a temporary collection
            oCopyOfZones = new Zones();
            foreach (Zone oLoopZone in this.Values)
            {
                oCopyOfZones.Add(oLoopZone);
            }


            return (oCopyOfZones);
        }
        public Zones GetClosestZones(Zone oTargetZone, int nNumToFind)
        {
            Zones oCopyOfZones = null;
            Zones oClosestZones = new Zones();
            Zone oClosestZone = null;


            //Copy the zones to a temporary collection
            oCopyOfZones = GetShallowCopy();

            //Now find the closest zones
            for (int nNumFound = 0; nNumFound < nNumToFind; nNumFound++)
            {
                //Find the single closest zone
                oClosestZone = null;
                foreach (Zone oLoopZone in oCopyOfZones.Values )
                {
                    if ( oTargetZone != oLoopZone && 
                         (
                            oClosestZone == null ||
                            DSMath.Distance(oClosestZone.X, oClosestZone.Y, oTargetZone.X, oTargetZone.Y) >
                            DSMath.Distance(oLoopZone.X, oLoopZone.Y, oTargetZone.X, oTargetZone.Y)
                         )
                       )
                    {
                        oClosestZone = oLoopZone;
                    }
                }

                //Remove the one we found from our temporary collection
                if (oClosestZone != null)
                {
                    oCopyOfZones.Remove(oClosestZone.ZoneID.ToString());
                    oClosestZones.Add(oClosestZone);
                }
            }


            return (oClosestZones);
        }

        #region Properties
        #endregion
    }

    public class Zone
    {
        #region Member Variables
        private DSNetPKey m_oPKey = null;
        private double m_nX = 0;
        private double m_nY = 0;
        private string m_sName = string.Empty;

        private Entitys m_oEntitys = new Entitys();
        private Entitys m_oSuperMassEntitys = new Entitys();

        //Temp variables never shared over network
        private ArrayList m_oRecentCollisions = new ArrayList();
        #endregion


        public Zone()
        {
            m_sName = "Zone " + DSMisc.GetRnd(1, 10000).ToString();
            m_oPKey = Globals.Inst().PrimaryKey.GetNewPrimarykey();
        }
        public void Advance(Session oSession,double nElapsedTime)
        {
            DSNetworkPlayer oPlayerOwner = null;
            Entity oLoopEntity = null;


            //Go through all our entitys, we know they won't be changing
            for (int nLoopEntityIdx = 0; nLoopEntityIdx < m_oEntitys.Count; nLoopEntityIdx++)
            {
                oLoopEntity = m_oEntitys.Values[nLoopEntityIdx];

                //This accounts for things like the player in the editor or docked
                if (oLoopEntity.IsInPlay == true)
                {
                    oLoopEntity.Advance(oSession, nElapsedTime);

                    if (Globals.Inst().IAmTheServer == true &&
                        oLoopEntity.TimeSinceLastLiteSend > oLoopEntity.DelayBetweenLiteSends())
                    {
                        oSession.TransmitEntity(oLoopEntity, false);
                    }
                    if (Globals.Inst().IAmTheServer == true &&
                        oLoopEntity.TimeSinceLastFullSend > oLoopEntity.DelayBetweenFullSends())
                    {
                        oSession.TransmitEntity(oLoopEntity, true);
                    }

                    //Check for dead people to respawn
                    if (Globals.Inst().IAmTheServer == true && oLoopEntity.IsDead == true)
                    {
                        if (oLoopEntity.OwnerSocketID != MiscConstants.m_cNOSOCKETIDASSIGNED &&
                            oLoopEntity.TimeHasBeenDead > 6)
                        {
                            oPlayerOwner = Globals.Inst().GameEngine.DirectPlay.GetPlayer(oLoopEntity.OwnerSocketID);

                            NetMsg.Send_EntityUpdate(Globals.Inst().GameEngine.DirectPlay, oPlayerOwner, oSession, oLoopEntity);
                            NetMsg.Send_Respawn(Globals.Inst().GameEngine.DirectPlay, oLoopEntity.OwnerSocketID);

                            oLoopEntity.OwnerSocketID = MiscConstants.m_cNOSOCKETIDASSIGNED;
                            oSession.RemoveEntity(oLoopEntity);
                        }
                        else if (oLoopEntity.OwnerSocketID == MiscConstants.m_cNOSOCKETIDASSIGNED &&
                                 oLoopEntity.TimeHasBeenDead > 15)
                        {
                            oSession.RemoveEntity(oLoopEntity);
                        }
                    }
                }
            }

            //Do our collision checks for this zone
            CollisionCheck(oSession, nElapsedTime);
        }

        public string Serialize(Session oSession)
        {
            string sRetVal = "";
            DSSerialize oSerialize = new DSSerialize();


            //Now save our data
            oSerialize.Set(0, m_oPKey.Serialize());
            oSerialize.SetList(1);
            foreach (Entity oLoopEntity in m_oEntitys.Values)
            {
                oSerialize.SetListItem(1, oLoopEntity.GetType().Name);
                oSerialize.SetListItem(1, oLoopEntity.Serialize(oSession));
            }
            oSerialize.Set(2, this.X);
            oSerialize.Set(3, this.Y);
            oSerialize.Set(4, this.Name);

            sRetVal = oSerialize.Serialize();


            return (sRetVal);
        }
        public void DeSerialize(Session oSession, string sZone)
        {
            DSSerialize oSerialize = new DSSerialize();
            Assembly oControlAssembly = null;
            Type oControlType = null;
            ArrayList oEntitys = null;
            Entity oNewEntity = null;
            Entity oLoopEntity = null;
            int nVersion = 0;


            oSerialize.DeSerialize(sZone, ref nVersion);

            m_oPKey.DeSerialize( (DSSerialize)oSerialize.Get(0) );
            oEntitys = oSerialize.GetList(1);
            //Walk the entitys and update them
            for (int i = 0; i < oEntitys.Count; i += 2)
            {
                //Deserialize the form into a new object... so first create the new object
                oControlAssembly = Assembly.Load("StellarLanes");
                oControlType = oControlAssembly.GetType("DarkStride.StellarLanes.SharedDLL." + (string)oEntitys[i]);
                //Make it!
                oNewEntity = (Entity)Activator.CreateInstance(oControlType, new object[] { });
                //Now deserialize the form
                oNewEntity.DeSerialize(oSession, (DSSerialize)oEntitys[i + 1]);


                //Do we have this entity?
                if (m_oEntitys.ContainsKey(oNewEntity.PKey) == false )
                {
                    AddEntity(oSession, oNewEntity, false);
                }
                else
                {
                    oLoopEntity = m_oEntitys[oNewEntity.PKey];
                    oLoopEntity.DeSerialize(oSession, (DSSerialize)oEntitys[i + 1]);
                }                

                //If we found it then update it, we can do this outside the lock
                if (oLoopEntity != null &&
                    (
                        Globals.Inst().OurShip == null ||
                        Globals.Inst().OurShip.PKey != oLoopEntity.PKey
                    )
                  )
                {
                    oLoopEntity.DeSerialize(oSession, (DSSerialize)oEntitys[i + 1]);
                }
            }

            this.X = oSerialize.GetDouble(2);
            this.Y = oSerialize.GetDouble(3);
            this.Name = oSerialize.GetString(4);
        }

        public void RemoveEntity(Session oSession, Entity oDelEntity)
        {
            this.Entitys.Remove(oSession, oDelEntity);
        }
        public void AddEntity(Session oSession, Entity oNewEntity, bool bNewEntityNeedsToBeResent)
        {
            oNewEntity.Location.ZoneID = this.ZoneID;
            this.Entitys.Add(oSession, oNewEntity, bNewEntityNeedsToBeResent);

            //Is it a supermass?
            if (oNewEntity.SuperMass == true)
            {
                this.SuperMassEntitys.Add(oSession, oNewEntity, false);
            }
        }
        public int GetPortalCount()
        {
            int nPortals = 0;

            foreach (Entity oLoopEntity in this.Entitys.Values)
            {
                if (oLoopEntity.GetType() == typeof(Portal))
                {
                    nPortals++;
                }
            }

            return (nPortals);
        }

        //Collisions
        private void CollisionCheck(Session oSession, double nElapsedTime)
        {
            ArrayList oEntity1Regions = null;
            ArrayList oEntity2Regions = null;
            Region oLoopReg1 = null;
            Region oLoopReg2 = null;
            RegionPoint oCollisionRegion = null;
            Entity oLoopEntity1 = null;
            Entity oLoopEntity2 = null;


            try
            {
                //Check for Collisions
                for (int nEntity1Index = 0; nEntity1Index < m_oEntitys.Count; nEntity1Index++)
                {
                    oLoopEntity1 = m_oEntitys.Values[nEntity1Index];
                    if (oLoopEntity1.IsInPlay == false ) { continue; }

                    for (int nEntity2Index = nEntity1Index + 1; nEntity2Index < m_oEntitys.Count; nEntity2Index++)
                    {
                        oLoopEntity2 = m_oEntitys.Values[nEntity2Index];
                        if (oLoopEntity2.IsInPlay == false ) { continue; }

                        //Does this collision even need to be checked?
                        if (oLoopEntity1.CollidesWithOtherEntitys == true && oLoopEntity2.CollidesWithOtherEntitys == true &&
                            oLoopEntity1.MostUpToDateLoc.ZoneID == oLoopEntity2.MostUpToDateLoc.ZoneID)
                        {
                            oEntity1Regions = oLoopEntity1.GetRegions();
                            oEntity2Regions = oLoopEntity2.GetRegions();

                            //Now compare the regions for any Collisions
                            for (int nReg1Index = 0; nReg1Index < oEntity1Regions.Count; nReg1Index++)
                            {
                                for (int nReg2Index = 0; nReg2Index < oEntity2Regions.Count; nReg2Index++)
                                {
                                    oLoopReg1 = (Region)oEntity1Regions[nReg1Index];
                                    oLoopReg2 = (Region)oEntity2Regions[nReg2Index];

                                    oCollisionRegion = oLoopReg1.HitTest(oLoopReg2);

                                    //We have a hit!
                                    if (oCollisionRegion != null)
                                    {
                                        CollideShips(oSession,oLoopEntity1, oLoopEntity2, nElapsedTime, oCollisionRegion);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (System.Exception oEx)
            {
                DSMisc.ShowErrors(oEx);
            }
        }
        private void CollideShips(Session oSession, Entity oEntity1, Entity oEntity2, double nElapsedTime, RegionPoint oCollisionRegion)
        {
            bool bCollide1 = false;
            bool bCollide2 = false;
            //Location oPostColEntity1_Loc = null; 
            //Location oPostColEntity2_Loc = null;
            //Location oPostColEntity1_SvrLoc = null;
            //Location oPostColEntity2_SvrLoc = null;
            CollisionInstance oLastCollision = null;
            CollisionInstance oNewCollision = null;


            //Check to see if we have collided to recently
            //oLastCollision = CheckForTheTimeOfTheLastCollisionBetweenTheseTwoEntities( oEntity1,oEntity2 );

            //Lets do the Collision recoils
            if (oEntity1.RecoilsAfterCollision == true &&
                oEntity2.RecoilsAfterCollision == true &&
                oLastCollision == null)
            {
                //Record our collision so we don't do it again too soon
                oNewCollision = new CollisionInstance(oEntity1, oEntity2, Globals.Inst().GameEngine.AppTime);
                m_oRecentCollisions.Add(oNewCollision);

                /*//The following code take care of Collision:
                ResolveCollisionVelocities( oCollisionRegion,oEntity1,oEntity2,
                                oEntity1.Location,oEntity2.Location,ref oPostColEntity1_Loc, ref oPostColEntity2_Loc );
                ResolveCollisionVelocities( oCollisionRegion,oEntity1,oEntity2,
                                oEntity1.MostUpToDateLoc,oEntity2.MostUpToDateLoc,ref oPostColEntity1_SvrLoc, ref oPostColEntity2_SvrLoc );

                //Resolve it
                oEntity1.Location = oPostColEntity1_Loc;
                if( oEntity1.ServerLocation != null )
                {
                    oEntity1.ServerLocation = oPostColEntity1_SvrLoc;
                }
                oEntity2.Location = oPostColEntity2_Loc;
                if( oEntity2.ServerLocation != null )
                {
                    oEntity2.ServerLocation = oPostColEntity2_SvrLoc;
                }*/
            }

            bCollide1 = oEntity1.Collision(oSession, oEntity2, nElapsedTime, oCollisionRegion);
            bCollide2 = oEntity2.Collision(oSession, oEntity1, nElapsedTime, oCollisionRegion);

            if (bCollide1 == true && bCollide2 == true && Globals.Inst().IAmTheServer == true &&
                (
                    oEntity1.TimeSinceLastCollision > .2 ||
                    oEntity2.TimeSinceLastCollision > .2
                )
              )
            {
                //Only send an update if this entity still exists
                if (oEntity1.TimeSinceLastCollision > .2 && this.Entitys.ContainsKey(oEntity1.PKey)  == true )
                {
                    oSession.TransmitEntity(oEntity1,true);
                    oEntity1.TimeSinceLastCollision = 0;
                }
                if (oEntity2.TimeSinceLastCollision > .2 && this.Entitys.ContainsKey(oEntity2.PKey) == true)
                {
                    oSession.TransmitEntity(oEntity2, true);
                    oEntity2.TimeSinceLastCollision = 0;
                }
            }
        }
        private void ResolveCollisionVelocities(Region oCollisionRegion,
                                Entity oEntity1, Entity oEntity2,
                                Location oEntity1PreCollisionLoc, Location oEntity2PreCollisionLoc,
                                ref Location oEntity1PostCollisionLoc, ref Location oEntity2PostCollisionLoc)
        {
            double vx1 = 0;
            double vy1 = 0;
            double vx2 = 0;
            double vy2 = 0;

            #region Unknown system from internet
            /*
			//You need to check the condition for Collision occurs.
			double dx = oEntity2PreCollisionLoc.Pos.X-oEntity1PreCollisionLoc.Pos.X, 
				   dy = oEntity2PreCollisionLoc.Pos.Y-oEntity1PreCollisionLoc.Pos.Y;
			// where x1,y1 are center of ball1, and x2,y2 are center of ball2
			double distance = Math.Sqrt(dx*dx+dy*dy) - 100;
			// Unit vector in the direction of the Collision
			double ax=dx/distance, ay=dy/distance; 
			// Projection of the velocities in these axes
			double va1=( oEntity1PreCollisionLoc.Vel.X*ax + oEntity1PreCollisionLoc.Vel.Y*ay), 
				   vb1=(-oEntity1PreCollisionLoc.Vel.X*ay + oEntity1PreCollisionLoc.Vel.Y*ax); 
			double va2=( oEntity2PreCollisionLoc.Vel.X*ax + oEntity2PreCollisionLoc.Vel.Y*ay), 
				   vb2=(-oEntity2PreCollisionLoc.Vel.X*ay + oEntity2PreCollisionLoc.Vel.Y*ax);
			// New velocities in these axes (after Collision): ed<=1, for elastic Collision ed=1
			double ed = 1;
			double mass1 = 1, mass2 = 1;
			double vaP1=va1 + (1+ed)*(va2-va1)/(1+mass1/mass2);
			double vaP2=va2 + (1+ed)*(va1-va2)/(1+mass2/mass1);
			// Undo the projections
			vx1 = vaP1*ax-vb1*ay; 
			vy1 = vaP1*ay+vb1*ax;
			vx2 = vaP2*ax-vb2*ay; 
			vy2 = vaP2*ay+vb2*ax;
			*/
            #endregion

            #region New sytem from internet (http://www.gamedev.net/community/forums/topic.asp?topic_id=208899&whichpage=1&#1339583)
            /*
			//New collision thing
			//x1 = 300;
			//y1 = 200;
			//r1 = 50;
			//r2 = 30;
			
			double r1 = 50;
			double r2 = 50;
			double angle = 0;
			double nCollisionX = 0;
			double nCollisionY = 0;
			double v = 0;

			//You need to check the condition for Collision occurs.
			double dx = oEntity1PreCollisionLoc.Pos.X-oEntity2PreCollisionLoc.Pos.X, 
				   dy = oEntity1PreCollisionLoc.Pos.Y-oEntity2PreCollisionLoc.Pos.Y;

			double oldx2 = oEntity2PreCollisionLoc.Pos.X;
			double oldy2 = oEntity2PreCollisionLoc.Pos.Y;
			//x2=mousex();
			//y2=mousey();

			//only calculate point of intersection if circles are intersecting
			if( (dx)^2 + (dy)^2 <= (r1+r2)^2 )
			{
				dx=x2-x1;
				dy=y2-y1;
				angle=Math.Atan(dx,dy);
			
				nCollisionX = x1 + Math.Cos( angle ) * r1;
				nCollisionY = y1 + Math.Sin( angle ) * r1;
				//hit = 1;
				//a = wrapvalue(angle+180);
				angle = DSMath.NormalizeRadAngle( angle + Math.PI );

				//show point of intersection
				//ink rgb(255,0,0),0
				//circle nCollisionX, nCollisionY,2
			}
			else
			{
				throw new System.Exception( "Error, system said collision but this said none" );
			}

			//if( hit == 1 )
			//{
				v = sqrt((oEntity2PreCollisionLoc.Vel.X)^2 + (oEntity2PreCollisionLoc.Vel.Y)^2);
				//v = 5;

				vx = 0 + Math.Cos( angle ) * v;
				vy = 0 + Math.Sin( angle ) * v;
				//vx=newxvalue(0,a,v);
				//vy=newzvalue(0,a,v);
				//moving = 1;
				//hit = 0;
			//}

			//if( moving == 1 )
			//{
				/*if( x1+r1 > screenwidth() )
				{
					vx=vx*-1;
				}

				if( x1 < r1 )
				{
					vx=vx*-1;
				}

				if( y1 < r1 )
				{
					vy=vy*-1;
				}

				if( y1+r1 > screenheight() )
				{
					vy=vy*-1;
				}

				a = atanfull(vx,vy);

				x1 = newxvalue(x1, a, v);
				y1 = newzvalue(y1, a, v);*/
            //}

            //set cursor 0,0
            //print mousemovex()
            //print mousemovey()
            //print a
            //print vx
            //print vy


            /*
Function NewXValue#(oldX#, amount#, angle) 
  cosine# = Math.Cos( angle )
  cosine# = Cosine# * amount#
  Newx# = oldx# + cosine#
  Return Newx#
End Function 

Function NewYValue#(oldY#, amount#, Angle#) 
  TempAngle# = Angle#
  sine# = Sin#(TempAngle#)
  sine# = sine# * amount#
  Newy# = (oldy# + sine#)
  Return Newy#
End Function

		
Function NewZValue#(current#,ang#,dist#)
    Return current+Cos(ang)*dist
End Function
         * */
            #endregion

            #region My math
            //Calculate the delta velocity of the impact
            double nDeltaVelX = oEntity2PreCollisionLoc.Vel.X - oEntity1PreCollisionLoc.Vel.X,
                   nDeltaVelY = oEntity2PreCollisionLoc.Vel.Y - oEntity1PreCollisionLoc.Vel.Y;
            double nAngleOfVel = 0;
            nAngleOfVel = DSMath.CalculateRadAngle(0, 0, nDeltaVelX, nDeltaVelY);
            /*if( nDeltaVelX == 0 || nDeltaVelY == 0 )
            {
                nAngleOfVel = 0;
            }
            else if( nDeltaVelX != 0 && nDeltaVelY != 0 )
            {
                nAngleOfVel = Math.Atan( nDeltaVelY / nDeltaVelX );
            }*/

            //F = MA
            double nMass1 = oEntity1.Mass,
                   nMass2 = oEntity2.Mass;
            //double nImpactForce = nMass1 * DSMath.Distance( 0,0,nDeltaVelX,nDeltaVelY );
            double nImpactForce = nMass1 * oEntity1PreCollisionLoc.Vel.Length() +
                                  nMass2 * oEntity2PreCollisionLoc.Vel.Length();

            ///////////////////////////////////////////////////////////////////////////////////////////
            //Collision Part 1
            ///////////////////////////////////////////////////////////////////////////////////////////
            //Get the angle of incidence
            RegionPoint oCollisionPt = (RegionPoint)oCollisionRegion;
            double nDistToCollision = DSMisc.Distance(oCollisionPt.Center.X, oCollisionPt.Center.Y,
                                                       oEntity1PreCollisionLoc.Pos.X, oEntity1PreCollisionLoc.Pos.Y);
            if (nDistToCollision == 0) { nDistToCollision = .001; }
            double nAngleToEntity = DSMath.CalculateRadAngle(oEntity1PreCollisionLoc.Pos.X, oEntity1PreCollisionLoc.Pos.Y, oCollisionRegion.ConvertToPointLocation().X, oCollisionRegion.ConvertToPointLocation().Y);
            double nAngleToCol = nAngleToEntity;//Math.Acos( ( oCollisionPt.Center.X - oEntity1PreCollisionLoc.Pos.X ) / nDistToCollision );
            nAngleToCol = DSMath.NormalizeRadAngle(nAngleToCol + Math.PI / 2.0);
            //double nAngleOfWall = DSMath.Angle90DegDiff( nAngleOfVel,nAngleToCol );
            double nAngleOfWall = DSMath.NormalizeRadAngle(nAngleToEntity + Math.PI / 2.0);

            double nAngleOfVelE1 = DSMath.CalculateRadAngle(0, 0, oEntity1PreCollisionLoc.Vel.X, oEntity1PreCollisionLoc.Vel.Y);
            double nAngleOfInc = DSMath.AngleRadDiff(nAngleToEntity, nAngleOfWall);
            double nBounceAngle = nAngleOfWall + nAngleOfInc;
            nBounceAngle = nAngleOfVelE1 + DSMath.AngleRadDiff(nAngleToEntity, nAngleOfInc) * 2;

            //Apply the main force
            //double nBounceAngle = nAngleOfVel - ( nAngleOfInc + ( Math.PI / 2.0 ) ) * 2.0;
            nBounceAngle = DSMath.NormalizeRadAngle(nBounceAngle);
            double nNewForce = nImpactForce * 2;//.95;//Math.Cos( nBounceAngle ) * nImpactForce;
            //nNewForce = Math.Abs( nNewForce );
            nNewForce = nImpactForce * (nMass1 / (nMass1 + nMass2));
            vx1 = oEntity1PreCollisionLoc.Vel.X + Math.Cos(nBounceAngle) * (-nNewForce / nMass1);
            vy1 = oEntity1PreCollisionLoc.Vel.Y - Math.Sin(nBounceAngle) * (-nNewForce / nMass1);



            ///////////////////////////////////////////////////////////////////////////////////////////
            //Collision Part 2
            ///////////////////////////////////////////////////////////////////////////////////////////
            //Apply the equal but opposite force
            nDistToCollision = DSMisc.Distance(oCollisionPt.Center.X, oCollisionPt.Center.Y,
                                                oEntity2PreCollisionLoc.Pos.X, oEntity2PreCollisionLoc.Pos.Y);
            if (nDistToCollision == 0) { nDistToCollision = .001; }

            nAngleToEntity = DSMath.CalculateRadAngle(oEntity2PreCollisionLoc.Pos.X, oEntity2PreCollisionLoc.Pos.Y, oCollisionRegion.ConvertToPointLocation().X, oCollisionRegion.ConvertToPointLocation().Y);
            nAngleToCol = nAngleToEntity;//Math.Acos( ( oCollisionPt.Center.X - oEntity1PreCollisionLoc.Pos.X ) / nDistToCollision );
            nAngleToCol = DSMath.NormalizeRadAngle(nAngleToCol + Math.PI / 2.0);
            //double nAngleOfWall = DSMath.Angle90DegDiff( nAngleOfVel,nAngleToCol );
            nAngleOfWall = DSMath.NormalizeRadAngle(nAngleToEntity + Math.PI / 2.0);
            //Switch this to 1
            double nAngleOfVelE2 = DSMath.CalculateRadAngle(0, 0, oEntity2PreCollisionLoc.Vel.X, oEntity2PreCollisionLoc.Vel.Y);
            nAngleOfInc = DSMath.AngleRadDiff(nAngleToEntity, nAngleOfWall);
            nBounceAngle = nAngleOfWall - nAngleOfInc;
            nBounceAngle = nAngleOfVelE2 + DSMath.AngleRadDiff(nAngleToEntity, nAngleOfInc) * 2;

            /*nAngleToCol = Math.Acos( ( oCollisionPt.Center.X - oEntity2PreCollisionLoc.Pos.X ) / nDistToCollision );
            nAngleOfInc = DSMath.NormalizeRadAngle( nAngleToCol + Math.PI / 2.0 );
            nBounceAngle = nAngleOfVel - ( nAngleOfInc + ( Math.PI / 2.0 ) ) * 2.0;*/
            nNewForce = Math.Cos(nBounceAngle) * nImpactForce * 2;
            nNewForce = Math.Abs(nNewForce);
            nNewForce = nImpactForce * 2;// * ( nMass2 / ( nMass1 + nMass2 ) );

            vx2 = oEntity2PreCollisionLoc.Vel.X - Math.Cos(nBounceAngle) * (-nNewForce / nMass2);
            vy2 = oEntity2PreCollisionLoc.Vel.Y + Math.Sin(nBounceAngle) * (-nNewForce / nMass2);
            #endregion


            oEntity1PostCollisionLoc = new Location(oEntity1PreCollisionLoc);
            if (oEntity1.SuperMass == false)
            {
                oEntity1PostCollisionLoc.Vel = new Vector2((float)vx1, (float)vy1);
            }
            oEntity2PostCollisionLoc = new Location(oEntity2PreCollisionLoc);
            if (oEntity2.SuperMass == false)
            {
                oEntity2PostCollisionLoc.Vel = new Vector2((float)vx2, (float)vy2);
            }
        }

        private CollisionInstance CheckForTheTimeOfTheLastCollisionBetweenTheseTwoEntities(Entity oEntity1, Entity oEntity2)
        {
            CollisionInstance oLoopCollision = null;
            CollisionInstance oRetVal = null;


            for (int i = 0; i < m_oRecentCollisions.Count; i++)
            {
                if (i >= m_oRecentCollisions.Count) { break; }
                oLoopCollision = (CollisionInstance)m_oRecentCollisions[i];

                if (Globals.Inst().GameEngine.AppTime - oLoopCollision.AppTimeOfCollision > 5)
                {
                    m_oRecentCollisions.RemoveAt(i);
                    i--;
                }
                else if (
                        (
                            oLoopCollision.Entity1.PKey == oEntity1.PKey &&
                            oLoopCollision.Entity2.PKey == oEntity2.PKey
                        )
                            ||
                        (
                            oLoopCollision.Entity2.PKey == oEntity1.PKey &&
                            oLoopCollision.Entity1.PKey == oEntity2.PKey
                        )
                      )
                {
                    oRetVal = oLoopCollision;
                }
            }


            return (oRetVal);
        }
        private void ResolveGravityBleeding(Entity oEntity, Entity oPlanet)
        {
            double nMinDist = 0;
            double nDist = 0;
            double nAngle = 0;
            ArrayList oRegionsEntity = null;
            ArrayList oRegionsPlanet = null;
            RegionCircle oLoopRegionEntity = null;
            RegionCircle oLoopRegionPlanet = null;


            oRegionsEntity = oEntity.GetRegions();
            oRegionsPlanet = oPlanet.GetRegions();

            for (int nEntityIndex = 0; nEntityIndex < oRegionsEntity.Count; nEntityIndex++)
            {
                oLoopRegionEntity = (RegionCircle)oRegionsEntity[nEntityIndex];

                for (int nPlanetIndex = 0; nPlanetIndex < oRegionsPlanet.Count; nPlanetIndex++)
                {
                    oLoopRegionPlanet = (RegionCircle)oRegionsPlanet[nPlanetIndex];

                    nMinDist = oLoopRegionEntity.Radius + oLoopRegionPlanet.Radius;
                    nDist = DSMath.Distance(oLoopRegionEntity.Center.X, oLoopRegionEntity.Center.Y,
                                             oLoopRegionPlanet.Center.X, oLoopRegionPlanet.Center.Y);
                    if (nDist < nMinDist)
                    {
                        nAngle = DSMath.CalculateRadAngle(
                                        oLoopRegionPlanet.Center.X, oLoopRegionPlanet.Center.Y,
                                        oLoopRegionEntity.Center.X, oLoopRegionEntity.Center.Y);
                        oEntity.Pos = new Vector2(
                                        (float)(oLoopRegionPlanet.Center.X + Math.Cos(nAngle) * nMinDist),
                                        (float)(oLoopRegionPlanet.Center.Y + Math.Sin(nAngle) * nMinDist));
                    }
                }
            }
        }

        public Vector2 GetGravitationalPull(double nElapsedTime, Vector2 vPos)
        {
            double nG = 5000000;
            double nDist = 0;
            double nForce = 0, nMaxForce = 0;
            double nAngleToMass = 0;
            Vector2 vGravPull = Vector2.Empty;


            //Go through all our entitys, we know they won't be changing
            foreach(SuperMass oLoopSuperMass in this.SuperMassEntitys.Values)
            {
                if (oLoopSuperMass.SuperMass == true && oLoopSuperMass.IsInPlay == true)
                {
                    nAngleToMass = DSMath.CalculateRadAngle(oLoopSuperMass.Pos.X, oLoopSuperMass.Pos.Y, vPos.X, vPos.Y);
                    nDist = DSMath.Distance(oLoopSuperMass.Pos, vPos) * 3;
                    nForce = ((oLoopSuperMass.Mass * nG) / (nDist * nDist)) * nElapsedTime;
                    nMaxForce = ((oLoopSuperMass.Mass * nG) / (oLoopSuperMass.MinRadius * oLoopSuperMass.MinRadius)) * nElapsedTime;

                    nForce = DSMisc.Min(nForce, nMaxForce);
                    if (nForce > 20)
                    {
                        vGravPull = new Vector2(
                            (float)(vGravPull.X + Math.Cos(nAngleToMass) * nForce),
                            (float)(vGravPull.Y + Math.Sin(nAngleToMass) * nForce));
                    }
                }
            }


            return (vGravPull);
        }


        #region Properties
        public DSNetPKey ZoneID
        {
            get
            {
                return (m_oPKey);
            }
        }
        public string PKey
        {
            get
            {
                return (m_oPKey.ToString());
            }
        }

        public double X
        {
            get
            {
                return (m_nX);
            }
            set
            {
                m_nX = value;
            }
        }
        public double Y
        {
            get
            {
                return (m_nY);
            }
            set
            {
                m_nY = value;
            }
        }
        public string Name
        {
            get
            {
                return (m_sName);
            }
            set
            {
                m_sName = value;
            }
        }

        public Entitys Entitys
        {
            get
            {
                return (m_oEntitys);
            }
        }
        public Entitys SuperMassEntitys
        {
            get
            {
                return (m_oSuperMassEntitys);
            }
        }
        #endregion
    }
}
